from typing import Union
from .RxMediaSource import RxMediaSource
from xlib import qt, qx, ax, mx
import numpy as np
from RxTimeline import RxTimelineGUI

class RxMediaSourceGUI(qx.QVBoxLayout):
    def __init__(self, vp : RxMediaSource):
        super().__init__()
        self._vp = vp
    
        self._error_holder = qx.QVBoxLayout()
        self._path_state_holder = qx.QVBoxLayout()
        self._canvas_holder = qx.QVBoxLayout()
        
        self._canvas_root = qx.QVBoxLayout()
        
        
        self.add_widgets(
            qx.QHBoxLayout().add_widgets(
                qx.QLabel().set_text('Media source').h_compact(),
                qx.QComboBoxRxSingleChoice(vp.mx_source_type),
                qx.QSpacer().h_expand(),
            ).v_compact(),
            
            self._path_state_holder.v_compact().hide(),
            
            #self._canvas_root
            
            self._error_holder.hide(),
            self._canvas_holder.hide(),
        )
        
        
        vp.mx_source_type.reflect(self._on_vp_mx_source_type)
        
        #qx.QLineEditRxTextState
        

    def dispose(self):
        super().dispose()
    
    def _on_vp_mx_source_type(self, source_type : RxMediaSource.SourceType):
        if source_type is RxMediaSource.SourceType.Unselected:
            self._path_state_holder.dispose_childs().hide()
            self._canvas_holder.dispose_childs().add_widgets(qx.QSpacer()).show()
            
        else:
            canvas = qx.QVBoxLayout()
            
            
            self._path_state_holder.dispose_childs().add_widgets(
                qx.QMxPathState(self._vp.mx_media_pathdlg),
            ).show()
            
            self._vp.mx_error.reflect(self._on_vp_mx_error).dispose_with(self)
            self._vp.mx_media_pathdlg.mx_path.reflect(self._on_vp_mx_media_path)
            
            
    def _on_vp_mx_error(self, error : Union[str, None]):
        if error is not None:
            self._canvas_holder.dispose_childs().add_widgets(
                    (qx.QLabel()                
                        .set_text(f'Error: {error}')
                        .set_text_interaction_flags(qx.QLabel.TextInteractionFlag.TextSelectableByMouse)
                        .set_word_wrap(True).set_font(qx.QFont.from_db(qx.EFontDB.FixedWidth))
                        .set_align(qx.Align.Center)
                    ),
                ).show()
        else:
            self._error_holder.add_widgets( qx.QSpacer() )
    
            

    def _on_vp_mx_media_path(self, path):
        print('_on_vp_mx_media_path', path)
        if path is not None:
            tl = self._vp.mx_timeline
            
            self._error_holder.dispose_childs()
            self._error_holder.hide()
            
            tl_gui = RxTimelineGUI(tl)
            
            
            self._canvas_holder.dispose_childs().add_widgets(
                #qx.QSpacer().v_expand(),
                
                qx.QPixmapWidgetRxNumpyState(self._vp.mx_frame),
                
                tl_gui,
                
            ).show()
            
            
        else:
            self._canvas_holder.dispose_childs().hide()
            
            self._error_holder.show()
            